﻿//////////////////////////////////////////////
// LogManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkLog
{
	class Logger ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkTasks
{
	class DLL_TASKS_EXPORT LogManager final : public nkCommon::SingletonClass<LogManager>
	{
		public :

			// Getters
			nkLog::Logger* getReceiver () const ;

			// Setters
			void setReceiver (nkLog::Logger* receiver) ;

			// Log
			void log (nkMemory::StringView message, nkMemory::StringView className) ;

		private :

			// Functions
			// Constructeur, destructeur
			LogManager () noexcept ;
			virtual ~LogManager () ;

		private :
			
			// Attributes
			nkLog::Logger* _receiver ;

		private :

			friend class nkCommon::SingletonClass<LogManager> ;
	} ;
}

